//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2

import wesual.data.Core 1.0
import wesual.Controls 1.0

PropertyEditor {
    id : editor

    function commit()  {
        if(!document)
            return;

        document.beginRecordChanges();
        document[editor.property] = !document[editor.property];
        document.endRecordChanges();
    }

    CheckBox {
        id : checkbox

        enabled : editor.document !== null
        checked : editor.document ? editor.document[editor.property] : false
        activeFocusOnTab : true

        onClicked : editor.commit()
    }
}
